<?php
/**
 * The template 'Style 2' to displaying related posts
 *
 * @package VETO
 * @since VETO 1.0
 */

$veto_link        = get_permalink();
$veto_post_format = get_post_format();
$veto_post_format = empty( $veto_post_format ) ? 'standard' : str_replace( 'post-format-', '', $veto_post_format );

?><div id="post-<?php the_ID(); ?>" <?php post_class( 'related_item post_format_' . esc_attr( $veto_post_format ) ); ?> data-post-id="<?php the_ID(); ?>">
	<?php
	veto_show_post_featured(
		array(
			'thumb_size' => apply_filters( 'veto_filter_related_thumb_size', veto_get_thumb_size(
				(int) veto_get_theme_option( 'related_posts' ) == 1 || (int) veto_get_theme_option( 'related_columns' ) == 1 ? 'full' : 'big' )
			),
		)
	);
	?>
	<div class="post_header entry-header">
		<?php
		if ( in_array( get_post_type(), array( 'post', 'attachment' ) ) ) {
			veto_show_post_meta(
				array(
					'components' => 'categories',
					'class'      => 'post_meta_categories',
				)
			);	
		}
		?>
		<h4 class="post_title entry-title"><a href="<?php echo esc_url( $veto_link ); ?>"><?php
			if ( '' == get_the_title() ) {
				esc_html_e( 'No title', 'veto' );
			} else {
				the_title();
			}
		?></a></h4>
		<?php
		if ( in_array( get_post_type(), array( 'post', 'attachment' ) ) ) {
			veto_show_post_meta(
				array(
					'components' => 'date, comments',
					'class'      => 'post_meta_info',
				)
			);	
		}
		?>
	</div>
</div>
