<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package VETO
 * @since VETO 1.0
 */

// Page (category, tag, archive, author) title

if ( veto_need_page_title() ) {
	veto_sc_layouts_showed( 'title', true );
	?>
	<div class="top_panel_title sc_layouts_row">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Blog/Page title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$veto_blog_title           = veto_get_blog_title();
							$veto_blog_title_text      = '';
							$veto_blog_title_class     = '';
							$veto_blog_title_link      = '';
							$veto_blog_title_link_text = '';
							if ( is_array( $veto_blog_title ) ) {
								$veto_blog_title_text      = $veto_blog_title['text'];
								$veto_blog_title_class     = ! empty( $veto_blog_title['class'] ) ? ' ' . $veto_blog_title['class'] : '';
								$veto_blog_title_link      = ! empty( $veto_blog_title['link'] ) ? $veto_blog_title['link'] : '';
								$veto_blog_title_link_text = ! empty( $veto_blog_title['link_text'] ) ? $veto_blog_title['link_text'] : '';
							} else {
								$veto_blog_title_text = $veto_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $veto_blog_title_class ); ?>">
								<?php
								$veto_top_icon = veto_get_term_image_small();
								if ( ! empty( $veto_top_icon ) ) {
									$veto_attr = veto_getimagesize( $veto_top_icon );
									?>
									<img src="<?php echo esc_url( $veto_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'veto' ); ?>"
										<?php
										if ( ! empty( $veto_attr[3] ) ) {
											veto_show_layout( $veto_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $veto_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $veto_blog_title_link ) && ! empty( $veto_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $veto_blog_title_link ); ?>" class="theme_button sc_layouts_title_link"><?php echo esc_html( $veto_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'veto_action_breadcrumbs' );
						$veto_breadcrumbs = ob_get_contents();
						ob_end_clean();
						veto_show_layout( $veto_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
