<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package VETO
 * @since VETO 1.0
 */

$veto_args = get_query_var( 'veto_logo_args' );

// Site logo
$veto_logo_type   = isset( $veto_args['type'] ) ? $veto_args['type'] : '';
$veto_logo_image  = veto_get_logo_image( $veto_logo_type );
$veto_logo_text   = veto_is_on( veto_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$veto_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $veto_logo_image['logo'] ) || ! empty( $veto_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $veto_logo_image['logo'] ) ) {
			if ( empty( $veto_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric( $veto_logo_image['logo'] ) && (int) $veto_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$veto_attr = veto_getimagesize( $veto_logo_image['logo'] );
				echo '<img src="' . esc_url( $veto_logo_image['logo'] ) . '"'
						. ( ! empty( $veto_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $veto_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $veto_logo_text ) . '"'
						. ( ! empty( $veto_attr[3] ) ? ' ' . wp_kses_data( $veto_attr[3] ) : '' )
						. '>';
			}
		} else {
			veto_show_layout( veto_prepare_macros( $veto_logo_text ), '<span class="logo_text">', '</span>' );
			veto_show_layout( veto_prepare_macros( $veto_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
