<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package VETO
 * @since VETO 1.0.06
 */

$veto_header_css   = '';
$veto_header_image = get_header_image();
if ( ! empty( $veto_header_image ) && veto_trx_addons_featured_image_override( veto_is_singular() || veto_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$veto_header_image = veto_get_current_mode_image( $veto_header_image );
}

$veto_header_id = veto_get_custom_header_id();
$veto_header_meta = veto_get_custom_layout_meta( $veto_header_id );
if ( ! empty( $veto_header_meta['margin'] ) ) {
	veto_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( veto_prepare_css_value( $veto_header_meta['margin'] ) ) ) );
	veto_storage_set( 'custom_header_margin', veto_prepare_css_value( $veto_header_meta['margin'] ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $veto_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $veto_header_id ) ) ); ?>
				<?php
				echo ! empty( $veto_header_image )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $veto_header_image ) {
					echo ' ' . esc_attr( veto_add_inline_css_class( 'background-image: url(' . esc_url( $veto_header_image ) . ');' ) );
				}
				if ( veto_is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				?>
">
	<?php

	// Custom header's layout
	do_action( 'veto_action_show_layout', $veto_header_id );

	?>
</header>
