<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package VETO
 * @since VETO 1.0.10
 */

// Footer sidebar
$veto_footer_name    = veto_get_theme_option( 'footer_widgets' );
$veto_footer_present = ! veto_is_off( $veto_footer_name ) && is_active_sidebar( $veto_footer_name );
if ( $veto_footer_present ) {
	veto_storage_set( 'current_sidebar', 'footer' );
	ob_start();
	if ( is_active_sidebar( $veto_footer_name ) ) {
		dynamic_sidebar( $veto_footer_name );
	}
	$veto_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $veto_out ) ) {
		$veto_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $veto_out );
		$veto_need_columns = true;   //or check: strpos($veto_out, 'columns_wrap')===false;
		if ( $veto_need_columns ) {
			$veto_columns = max( 0, (int) veto_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $veto_columns ) {
				$veto_columns = min( 4, max( 1, veto_tags_count( $veto_out, 'aside' ) ) );
			}
			if ( $veto_columns > 1 ) {
				$veto_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $veto_columns ) . ' widget', $veto_out );
			} else {
				$veto_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area sc_layouts_row">
			<?php do_action( 'veto_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<div class="content_wrap">
					<?php
					if ( $veto_need_columns ) {
						?>
						<div class="columns_wrap">
						<?php
					}
					do_action( 'veto_action_before_sidebar', 'footer' );
					veto_show_layout( $veto_out );
					do_action( 'veto_action_after_sidebar', 'footer' );
					if ( $veto_need_columns ) {
						?>
						</div>
						<?php
					}
					?>
				</div>
			</div>
			<?php do_action( 'veto_action_after_sidebar_wrap', 'footer' ); ?>
		</div>
		<?php
	}
}
