<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package VETO
 * @since VETO 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
				<?php
					$veto_copyright = veto_get_theme_option( 'copyright' );
					if ( ! empty( $veto_copyright ) ) {
						// Replace {{Y}} or {Y} with the current year
						$veto_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $veto_copyright );
						// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
						$veto_copyright = veto_prepare_macros( $veto_copyright );
						// Display copyright
						echo wp_kses( nl2br( $veto_copyright ), 'veto_kses_content' );
					}
				?>
			</div>
		</div>
	</div>
</div>