<?php
/**
 * The template to display the user's avatar, bio and socials on the Author page
 *
 * @package VETO
 * @since VETO 1.71.0
 */
?>

<div class="author_page author vcard" itemprop="author" itemscope="itemscope" itemtype="<?php echo esc_attr( veto_get_protocol( true ) ); ?>//schema.org/Person">

	<div class="author_avatar" itemprop="image">
		<?php
		$veto_mult = veto_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 120 * $veto_mult );
		?>
	</div>

	<h4 class="author_title" itemprop="name"><span class="fn"><?php the_author(); ?></span></h4>

	<?php
	$veto_author_description = get_the_author_meta( 'description' );
	if ( ! empty( $veto_author_description ) ) {
		?>
		<div class="author_bio" itemprop="description"><?php echo wp_kses( wpautop( $veto_author_description ), 'veto_kses_content' ); ?></div>
		<?php
	}
	?>

	<div class="author_details">
		<span class="author_posts_total">
			<?php
			$veto_posts_total = count_user_posts( get_the_author_meta('ID'), 'post' );	// get_the_author_posts() return posts number by post_type from first post in the result
			if ( $veto_posts_total > 0 ) {
				// Translators: Add the author's posts number to the message
				echo wp_kses( sprintf( _n( '%s article published', '%s articles published', $veto_posts_total, 'veto' ),
										'<span class="author_posts_total_value">' . number_format_i18n( $veto_posts_total ) . '</span>'
								 		),
							'veto_kses_content'
							);
			} else {
				esc_html_e( 'No posts published.', 'veto' );
			}
			?>
		</span><?php
			ob_start();
			do_action( 'veto_action_user_meta', 'author-page' );
			$veto_socials = ob_get_contents();
			ob_end_clean();
			veto_show_layout( $veto_socials,
				'<span class="author_socials"><span class="author_socials_caption">' . esc_html__( 'Follow:', 'veto' ) . '</span>',
				'</span>'
			);
		?>
	</div>

</div>
