<?php
/**
 * The template to display Admin notices
 *
 * @package VETO
 * @since VETO 1.0.1
 */

$veto_theme_slug = get_template();
$veto_theme_obj  = wp_get_theme( $veto_theme_slug );
?>
<div class="veto_admin_notice veto_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$veto_theme_img = veto_get_file_url( 'screenshot.jpg' );
	if ( '' != $veto_theme_img ) {
		?>
		<div class="veto_notice_image"><img src="<?php echo esc_url( $veto_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'veto' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="veto_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'veto' ),
				$veto_theme_obj->get( 'Name' ) . ( VETO_THEME_FREE ? ' ' . __( 'Free', 'veto' ) : '' ),
				$veto_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="veto_notice_text">
		<p class="veto_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $veto_theme_obj->description ) );
			?>
		</p>
		<p class="veto_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'veto' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="veto_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=veto_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'veto' );
			?>
		</a>
	</div>
</div>
