<?php
// Add theme-specific CSS-animations
if ( ! function_exists( 'veto_elm_add_theme_animations' ) ) {
	add_filter( 'elementor/controls/animations/additional_animations', 'veto_elm_add_theme_animations' );
	function veto_elm_add_theme_animations( $animations ) {
		/* To add a theme-specific animations to the list:
			1) Merge to the array 'animations': array(
													esc_html__( 'Theme Specific', 'veto' ) => array(
														'ta_custom_1' => esc_html__( 'Custom 1', 'veto' )
													)
												)
			2) Add a CSS rules for the class '.ta_custom_1' to create a custom entrance animation
		*/
		$animations = array_merge(
						$animations,
						array(
							esc_html__( 'Theme Specific', 'veto' ) => array(
																			'ta_fadeinup' 		=> esc_html__( 'Fade In Up (Short)', 'veto' ),
																			'ta_fadeinright'	=> esc_html__( 'Fade In Right (Short)', 'veto' ),
																			'ta_fadeinleft'		=> esc_html__( 'Fade In Left (Short)', 'veto' ),
																			'ta_fadeindown'		=> esc_html__( 'Fade In Down (Short)', 'veto' ),
																			'ta_fadein' 		=> esc_html__( 'Fade In (Short)', 'veto' ),
																			'ta_popup' 			=> esc_html__( 'Pop Up', 'veto' ),
																			'ta_infiniterotate' => esc_html__( 'Infinite Rotate', 'veto' ),
																			)
							)
						);
		return $animations;
	}
}
