<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package VETO
 * @since VETO 1.0
 */

$veto_template = apply_filters( 'veto_filter_get_template_part', veto_blog_archive_get_template() );

if ( ! empty( $veto_template ) && 'index' != $veto_template ) {

	get_template_part( $veto_template );

} else {

	veto_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$veto_stickies   = is_home()
								|| ( in_array( veto_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) veto_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$veto_post_type  = veto_get_theme_option( 'post_type' );
		$veto_args       = array(
								'blog_style'     => veto_get_theme_option( 'blog_style' ),
								'post_type'      => $veto_post_type,
								'taxonomy'       => veto_get_post_type_taxonomy( $veto_post_type ),
								'parent_cat'     => veto_get_theme_option( 'parent_cat' ),
								'posts_per_page' => veto_get_theme_option( 'posts_per_page' ),
								'sticky'         => veto_get_theme_option( 'sticky_style', 'inherit' ) == 'columns'
															&& is_array( $veto_stickies )
															&& count( $veto_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		veto_blog_archive_start();

		do_action( 'veto_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'veto_action_before_page_author' );
			get_template_part( apply_filters( 'veto_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'veto_action_after_page_author' );
		}

		if ( veto_get_theme_option( 'show_filters', 0 ) ) {
			do_action( 'veto_action_before_page_filters' );
			veto_show_filters( $veto_args );
			do_action( 'veto_action_after_page_filters' );
		} else {
			do_action( 'veto_action_before_page_posts' );
			veto_show_posts( array_merge( $veto_args, array( 'cat' => $veto_args['parent_cat'] ) ) );
			do_action( 'veto_action_after_page_posts' );
		}

		do_action( 'veto_action_blog_archive_end' );

		veto_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'veto_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'veto_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
