<?php
$veto_woocommerce_sc = veto_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $veto_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$veto_scheme = veto_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $veto_scheme ) && ! veto_is_inherit( $veto_scheme ) ) {
			echo ' scheme_' . esc_attr( $veto_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( veto_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( veto_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$veto_css      = '';
			$veto_bg_image = veto_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $veto_bg_image ) ) {
				$veto_css .= 'background-image: url(' . esc_url( veto_get_attachment_url( $veto_bg_image ) ) . ');';
			}
			if ( ! empty( $veto_css ) ) {
				echo ' style="' . esc_attr( $veto_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$veto_anchor_icon = veto_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$veto_anchor_text = veto_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $veto_anchor_icon ) || ! empty( $veto_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $veto_anchor_icon ) ? ' icon="' . esc_attr( $veto_anchor_icon ) . '"' : '' )
											. ( ! empty( $veto_anchor_text ) ? ' title="' . esc_attr( $veto_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( veto_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' veto-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$veto_css      = '';
				$veto_bg_mask  = veto_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$veto_bg_color_type = veto_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $veto_bg_color_type ) {
					$veto_bg_color = veto_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $veto_bg_color_type ) {
					$veto_bg_color = veto_get_scheme_color( 'bg_color', $veto_scheme );
				} else {
					$veto_bg_color = '';
				}
				if ( ! empty( $veto_bg_color ) && $veto_bg_mask > 0 ) {
					$veto_css .= 'background-color: ' . esc_attr(
						1 == $veto_bg_mask ? $veto_bg_color : veto_hex2rgba( $veto_bg_color, $veto_bg_mask )
					) . ';';
				}
				if ( ! empty( $veto_css ) ) {
					echo ' style="' . esc_attr( $veto_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$veto_caption     = veto_get_theme_option( 'front_page_woocommerce_caption' );
				$veto_description = veto_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $veto_caption ) || ! empty( $veto_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $veto_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $veto_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $veto_caption, 'veto_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $veto_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $veto_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $veto_description ), 'veto_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $veto_woocommerce_sc ) {
						$veto_woocommerce_sc_ids      = veto_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$veto_woocommerce_sc_per_page = count( explode( ',', $veto_woocommerce_sc_ids ) );
					} else {
						$veto_woocommerce_sc_per_page = max( 1, (int) veto_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$veto_woocommerce_sc_columns = max( 1, min( $veto_woocommerce_sc_per_page, (int) veto_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$veto_woocommerce_sc}"
										. ( 'products' == $veto_woocommerce_sc
												? ' ids="' . esc_attr( $veto_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $veto_woocommerce_sc
												? ' category="' . esc_attr( veto_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $veto_woocommerce_sc
												? ' orderby="' . esc_attr( veto_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( veto_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $veto_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $veto_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
