<div class="front_page_section front_page_section_testimonials<?php
	$veto_scheme = veto_get_theme_option( 'front_page_testimonials_scheme' );
	if ( ! empty( $veto_scheme ) && ! veto_is_inherit( $veto_scheme ) ) {
		echo ' scheme_' . esc_attr( $veto_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( veto_get_theme_option( 'front_page_testimonials_paddings' ) );
	if ( veto_get_theme_option( 'front_page_testimonials_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$veto_css      = '';
		$veto_bg_image = veto_get_theme_option( 'front_page_testimonials_bg_image' );
		if ( ! empty( $veto_bg_image ) ) {
			$veto_css .= 'background-image: url(' . esc_url( veto_get_attachment_url( $veto_bg_image ) ) . ');';
		}
		if ( ! empty( $veto_css ) ) {
			echo ' style="' . esc_attr( $veto_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$veto_anchor_icon = veto_get_theme_option( 'front_page_testimonials_anchor_icon' );
	$veto_anchor_text = veto_get_theme_option( 'front_page_testimonials_anchor_text' );
if ( ( ! empty( $veto_anchor_icon ) || ! empty( $veto_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_testimonials"'
									. ( ! empty( $veto_anchor_icon ) ? ' icon="' . esc_attr( $veto_anchor_icon ) . '"' : '' )
									. ( ! empty( $veto_anchor_text ) ? ' title="' . esc_attr( $veto_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_testimonials_inner
	<?php
	if ( veto_get_theme_option( 'front_page_testimonials_fullheight' ) ) {
		echo ' veto-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$veto_css      = '';
			$veto_bg_mask  = veto_get_theme_option( 'front_page_testimonials_bg_mask' );
			$veto_bg_color_type = veto_get_theme_option( 'front_page_testimonials_bg_color_type' );
			if ( 'custom' == $veto_bg_color_type ) {
				$veto_bg_color = veto_get_theme_option( 'front_page_testimonials_bg_color' );
			} elseif ( 'scheme_bg_color' == $veto_bg_color_type ) {
				$veto_bg_color = veto_get_scheme_color( 'bg_color', $veto_scheme );
			} else {
				$veto_bg_color = '';
			}
			if ( ! empty( $veto_bg_color ) && $veto_bg_mask > 0 ) {
				$veto_css .= 'background-color: ' . esc_attr(
					1 == $veto_bg_mask ? $veto_bg_color : veto_hex2rgba( $veto_bg_color, $veto_bg_mask )
				) . ';';
			}
			if ( ! empty( $veto_css ) ) {
				echo ' style="' . esc_attr( $veto_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_testimonials_content_wrap content_wrap">
			<?php
			// Caption
			$veto_caption = veto_get_theme_option( 'front_page_testimonials_caption' );
			if ( ! empty( $veto_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_testimonials_caption front_page_block_<?php echo ! empty( $veto_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $veto_caption, 'veto_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$veto_description = veto_get_theme_option( 'front_page_testimonials_description' );
			if ( ! empty( $veto_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_testimonials_description front_page_block_<?php echo ! empty( $veto_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $veto_description ), 'veto_kses_content' ); ?></div>
				<?php
			}

			// Content (widgets)
			?>
			<div class="front_page_section_output front_page_section_testimonials_output">
				<?php
				if ( is_active_sidebar( 'front_page_testimonials_widgets' ) ) {
					dynamic_sidebar( 'front_page_testimonials_widgets' );
				} elseif ( current_user_can( 'edit_theme_options' ) ) {
					if ( ! veto_exists_trx_addons() ) {
						veto_customizer_need_trx_addons_message();
					} else {
						veto_customizer_need_widgets_message( 'front_page_testimonials_caption', 'ThemeREX Addons - Testimonials' );
					}
				}
				?>
			</div>
		</div>
	</div>
</div>
