/**
 * Login and Register
 *
 * @package ThemeREX Addons
 * @since v1.5
 */

/* global jQuery, TRX_ADDONS_STORAGE */

jQuery(document).on('action.ready_trx_addons', function() {

	"use strict";

/*
	// Show/Hide user menu
	if (jQuery('.trx_addons_login_link:not(.inited)').length > 0) {
		jQuery('.trx_addons_login_link:not(.inited)').addClass('inited').on('click', function(e){
			jQuery(this).find('.trx_addons_login_menu').slideToggle().parent().toggleClass('menu_opened');
			e.preventDefault();
			return false;
		});
		jQuery('body').on('click', function(e){
			jQuery(this).find('.trx_addons_login_menu:visible').slideUp().parent().removeClass('menu_opened');
		});
	}
*/

	// Validate Login form
	jQuery( 'form.trx_addons_popup_form_login:not(.inited)')
		.addClass('inited')
		.on( 'submit', function(e) {
			var rez = trx_addons_login_validate(jQuery(this));
			if ( !rez ) {
				e.preventDefault();
			}
			return rez;
		} );
	
	// Validate Registration form
	jQuery( 'form.trx_addons_popup_form_register:not(.inited)')
		.addClass('inited')
		.on( 'submit', function(e) {
			var rez = trx_addons_registration_validate(jQuery(this));
			if ( !rez ) {
				e.preventDefault();
			}
			return rez;
		} );
	
	// Login form validation
	function trx_addons_login_validate(form) {
		form.find('input').removeClass('trx_addons_field_error');
		var error = trx_addons_form_validate(form, {
			error_message_time: 4000,
			exit_after_first_error: true,
			rules: [
				{
					field: "log",
					min_length: { value: 1, message: TRX_ADDONS_STORAGE['msg_login_empty'] },
					max_length: { value: 60, message: TRX_ADDONS_STORAGE['msg_login_long'] }
				},
				{
					field: "pwd",
					min_length: { value: 1, message: TRX_ADDONS_STORAGE['msg_password_empty'] },
					max_length: { value: 60, message: TRX_ADDONS_STORAGE['msg_password_long'] }
				}
			]
		});
		if (TRX_ADDONS_STORAGE['login_via_ajax'] && !error) {
			trx_addons_login_ajax_loading( form, true );
			jQuery.post(TRX_ADDONS_STORAGE['ajax_url'], {
				action: 'trx_addons_login_user',
				nonce: TRX_ADDONS_STORAGE['ajax_nonce'],
				redirect_to: form.find('input[name="redirect_to"]').length == 1 ? form.find('input[name="redirect_to"]').val() : '',
				remember: form.find('input[name="rememberme"]').val(),
				user_log: form.find('input[name="log"]').val(),
				user_pwd: form.find('input[name="pwd"]').val()
			}).done( function( response ) {
				trx_addons_login_ajax_loading( form, false );
				var rez = trx_addons_parse_ajax_response( response );
				var result = form.find(".trx_addons_message_box")
								.removeClass("trx_addons_message_box_error")
								.removeClass("trx_addons_message_box_success"),
					result_timeout = 3000;
				if ( rez.error === '' ) {
					result.addClass("trx_addons_message_box_success").html(TRX_ADDONS_STORAGE['msg_login_success']);
					setTimeout( function() {
						// Get a new URL to redirect after login
						var new_url = rez.redirect_to !== ''
										? ( rez.redirect_to.indexOf( 'action=confirm_email' ) != -1
											? rez.redirect_to.substr( 0, rez.redirect_to.indexOf('?') )
											: rez.redirect_to
											)
										: ( location.href.indexOf( 'action=confirm_email' ) != -1
											? TRX_ADDONS_STORAGE['site_url']
											: location.href
											);
						// Add random string to the URL to prevent caching
						new_url = trx_addons_add_to_url( new_url, { rnd: trx_addons_get_unique_id() } );
						// Redirect to the new URL
						location.href = trx_addons_apply_filters( 'trx_addons_filter_redirect_url_after_login', new_url, rez );
					}, result_timeout );
				} else {
					result.addClass("trx_addons_message_box_error").html(TRX_ADDONS_STORAGE['msg_login_error'] + (rez.error!==undefined ?  '<br>' + rez.error : ''));
				}
				result.fadeIn().delay(result_timeout).fadeOut();
				jQuery(document).trigger(' action.got_ajax_response', {
					action: 'trx_addons_login_user',
					result: rez
				});
			});
		}
		return !TRX_ADDONS_STORAGE['login_via_ajax'] && !error;
	}
	

	// Fix a redirect URL for compatibility with the LearnPress plugin: 
	// if the plugin is active and the courses archive page is set as the homepage -
	// adding the parameter 'rnd' to the URL will cause a redirect to the homepage.
	trx_addons_add_filter( 'trx_addons_filter_redirect_url_after_login', function( url, rez ) {
		if ( typeof lpData != 'undefined' && lpData.site_url === TRX_ADDONS_STORAGE['site_url'] ) {
			url = lpData.site_url;
		}
		return url;
	} );

	
	// Registration form validation
	function trx_addons_registration_validate(form) {
		form.find('input').removeClass('trx_addons_field_error');
		var error = trx_addons_form_validate(form, {
			error_message_time: 4000,
			exit_after_first_error: true,
			rules: [
				{
					field: "agree",
					state: { value: 'checked', message: TRX_ADDONS_STORAGE['msg_not_agree'] },
				},
				{
					field: "log",
					min_length: { value: 1, message: TRX_ADDONS_STORAGE['msg_login_empty'] },
					max_length: { value: 60, message: TRX_ADDONS_STORAGE['msg_login_long'] }
				},
				{
					field: "email",
					min_length: { value: 7, message: TRX_ADDONS_STORAGE['msg_email_not_valid'] },
					max_length: { value: 60, message: TRX_ADDONS_STORAGE['msg_email_long'] },
					mask: { value: TRX_ADDONS_STORAGE['email_mask'], message: TRX_ADDONS_STORAGE['msg_email_not_valid'] }
				},
				{
					field: "pwd",
					min_length: { value: 4, message: TRX_ADDONS_STORAGE['msg_password_empty'] },
					max_length: { value: 60, message: TRX_ADDONS_STORAGE['msg_password_long'] }
				},
				{
					field: "pwd2",
					equal_to: { value: 'pwd', message: TRX_ADDONS_STORAGE['msg_password_not_equal'] }
				}
			]
		});
		if (!error) {
			trx_addons_login_ajax_loading( form, true );
			jQuery.post(TRX_ADDONS_STORAGE['ajax_url'], {
				action: 'trx_addons_registration_user',
				nonce: TRX_ADDONS_STORAGE['ajax_nonce'],
				redirect_to: form.find('input[name="redirect_to"]').length == 1 ? form.find('input[name="redirect_to"]').val() : '',
				user_name: 	form.find('input[name="log"]').val(),
				user_email: form.find('input[name="email"]').val(),
				user_pwd: 	form.find('input[name="pwd"]').val()
			}).done( function( response ) {
				trx_addons_login_ajax_loading( form, false );
				var rez = trx_addons_parse_ajax_response( response );
				var result = form.find(".trx_addons_message_box")
								.removeClass("trx_addons_message_box_error")
								.removeClass("trx_addons_message_box_success"),
					result_timeout = 3000;
				if (rez.error === '') {
					result.addClass("trx_addons_message_box_success").html(TRX_ADDONS_STORAGE['msg_registration_success']);
					if ( ! TRX_ADDONS_STORAGE['double_opt_in_registration'] ) {
						setTimeout( function() { 
							if ( rez.redirect_to !== '' && trx_addons_apply_filters( 'trx_addons_filter_redirect_after_user_registration', false, rez.redirect_to ) ) {
								location.href = rez.redirect_to;
							} else {
								jQuery('#trx_addons_login_popup .trx_addons_tabs_title_login > a').trigger('click'); 
							}
						}, result_timeout );
					} else {
						result_timeout = 5000;
						setTimeout( function() { 
							jQuery( '#trx_addons_login_popup .mfp-close').trigger( 'click' );
						}, result_timeout );
					}
				} else {
					result.addClass("trx_addons_message_box_error").html(TRX_ADDONS_STORAGE['msg_registration_error'] + (rez.error!==undefined ?  '<br>' + rez.error : ''));
				}
				result.fadeIn().delay(result_timeout).fadeOut();
				jQuery( document ).trigger( 'action.got_ajax_response', {
					action: 'trx_addons_registration_user',
					result: rez
				});
			});
		}
		return false;
	}

	// Show/hide loading waiting block
	function trx_addons_login_ajax_loading( form, on ) {
		var $popup = form.parents( ".trx_addons_popup" );
		var $loading = $popup.find( ".trx_addons_loading" );
		if ( $loading.length == 0 ) {
			$popup.append( '<div class="trx_addons_loading"></div>' );
			$loading = $popup.find( " > .trx_addons_loading" );
		}
		if ( on ) {
			$loading.fadeIn();
		} else {
			$loading.fadeOut();
		}
	}

});