/* global jQuery, TRX_ADDONS_STORAGE */

jQuery(document).ready(function(){

	"use strict";

	// Start banners rotator (if visible)
	if ( !jQuery('.trx_banners_section').hasClass('trx_addons_hidden') ) {
		trx_addons_banners_rotator('.trx_banners_section');
	}

	// Hide/Show list of pages on change import_posts
	jQuery('#trx_importer_form .trx_importer_item_posts').on('change', function() {
		var posts = jQuery(this);
		if ( jQuery('#trx_importer_form [name="demo_set"]:checked').val() == 'part' ) {
			if ( ! posts.get(0).checked && posts.hasClass('trx_addons_checkbox_particular') ) {
				posts.get(0).checked = true;
			}
			jQuery('.trx_importer_part_pages input[type="checkbox"]').each(function() {
				jQuery(this).get(0).checked = posts.get(0).checked;
			});
			posts.removeClass('trx_addons_checkbox_particular');
		}
	});
	jQuery('#trx_importer_form').on('change', '.trx_importer_part_pages input[type="checkbox"]', function() {
		var all = jQuery(this).parents('.trx_importer_part_pages').find('input[type="checkbox"]').length,
			checked = jQuery(this).parents('.trx_importer_part_pages').find('input[type="checkbox"]:checked').length,
			need_posts = jQuery('#trx_importer_form .trx_importer_item[data-need-posts="1"]:checked').length;
		jQuery('#trx_importer_form .trx_importer_item_posts')
			.toggleClass( 'trx_addons_checkbox_particular', checked > 0 && checked < all || checked == 0 && need_posts > 0 )
			.get(0).checked = checked > 0 || need_posts > 0;
	});

	// Mark 'import_posts' as 'particular' if it's not selected and the item with data 'need-posts' is selected
	jQuery('#trx_importer_form .trx_importer_item[data-need-posts="1"]').on('change', function() {
		var posts = jQuery('#trx_importer_form .trx_importer_item_posts');
		if ( jQuery('#trx_importer_form [name="demo_set"]:checked').val() == 'part' ) {
			if ( jQuery(this).get(0).checked ) {
				if ( ! posts.get(0).checked ) {
					posts.get(0).checked = true;
					posts.toggleClass('trx_addons_checkbox_particular', true);
				}
			} else {
				var pages_all = jQuery('.trx_importer_part_pages input[type="checkbox"]').length,
					pages_checked = jQuery('.trx_importer_part_pages input[type="checkbox"]:checked').length,
					need_posts = jQuery('#trx_importer_form .trx_importer_item[data-need-posts="1"]:checked').length;
				if ( posts.get(0).checked ) {
					posts.get(0).checked = pages_checked > 0 || need_posts > 0;
					posts.toggleClass('trx_addons_checkbox_particular', pages_checked > 0 && pages_checked < pages_all || pages_checked == 0 && need_posts > 0);
				}
				jQuery('#trx_importer_form .trx_importer_part_pages input[type="checkbox"]:checked').length
			}
		}
	});

	// Change demo type
	jQuery('.trx_importer_demo_type input[type="radio"],.trx_importer_skins select').on('change', function() {
		var $field = jQuery(this);
		var type = $field.val();
		// Clear all checkboxes if the skin selected
		if ( $field.closest( '.trx_importer_skins' ).length > 0 ) {
			var $form = $field.parents('form');
			$form.find('input[type="checkbox"].trx_importer_item').each( function() {
				jQuery(this).get(0).checked = false;
			} );
			if ( type ) {
				$form.find('.trx_importer_params,.trx_importer_advanced_settings_plugins' ).hide();
			} else {
				$form.find('.trx_importer_params,.trx_importer_advanced_settings_plugins' ).show();
			}
		}

		// Refresh list of the pages
		var data = {
			ajax_nonce: TRX_ADDONS_STORAGE['ajax_nonce'],
			action: 'trx_addons_importer_get_list_pages',
			demo_type: type,
			is_admin_request: 1
		};
		jQuery('.trx_importer_part_pages').addClass('trx_addons_loading');
		jQuery.post( TRX_ADDONS_STORAGE['ajax_url'], data, function( response ) {
			var rez = trx_addons_parse_ajax_response( response );
			if (rez.error === '') {
				var html = '';
				for (var i in rez.data) {
					html += '<label class="trx_importer_checkbox_label trx_importer_pages_label">'
							+ '<input class="trx_importer_pages" type="checkbox" value="' + rez.data[i].id + '" name="import_pages_' + rez.data[i].id + '" id="import_pages_' + rez.data[i].id + '" />'
							+ ' ' + rez.data[i].title
							+ '</label>';
				}
				jQuery('.trx_importer_part_pages').html( html ).removeClass('trx_addons_loading');
			}
		});
	});

	// Demo set radio buttons
	jQuery('.trx_importer_demo_set input[type="radio"]').on('change', function() {
		var set = jQuery(this).val(),
			set_controls = jQuery(this).parents('.trx_importer_demo_set_controls');
		// Confirm about full installation
		if (set == 'full') {
			trx_addons_msgbox_agree(
				TRX_ADDONS_STORAGE['msg_importer_full_alert'],
				TRX_ADDONS_STORAGE['msg_caption_warning'],
				function(btn) {
					if (btn == 1) {
						trx_addons_importer_change_demo_set(set);
					} else {
						set_controls.find('input[type="radio"]').removeAttr('checked').get(0).checked = true;
					}
				}
			);
		} else {
			trx_addons_importer_change_demo_set(set);
		}
	});
	jQuery('.trx_importer_demo_set input[type="radio"]').eq(0).trigger('change');

	// Change demo set
	function trx_addons_importer_change_demo_set(set) {
		var set_controls = jQuery('.trx_importer_demo_set_controls'),
			set_radio = set_controls.find('input[type="radio"][value="'+set+'"]'),
			set_form = set_controls.parents('form');
		set_controls.find('label').removeClass('trx_importer_demo_set_active');
		set_radio.parent().addClass('trx_importer_demo_set_active');
		// Check all components if full installation is checked and uncheck otherwise
		jQuery('.trx_importer_advanced_settings_block > label > input[type="checkbox"],.trx_importer_advanced_settings_block > .trx_importer_params > label > input[type="checkbox"]').each(function() {
			this.checked = set == 'full';
			var chk = jQuery(this);
			if ( chk.hasClass('trx_importer_item_posts') ) {
				var all = jQuery(this).parents('.trx_importer_part_pages').find('input[type="checkbox"]').length,
					checked = jQuery(this).parents('.trx_importer_part_pages').find('input[type="checkbox"]:checked').length;
				chk.toggleClass( 'trx_addons_checkbox_particular', set == 'part' && checked > 0 && checked < all );
			}
			chk.trigger('change');
		});
		// Show/hide description of the set
		set_radio.parents('form')
			.find('.trx_importer_description:not(.trx_importer_description_both)').slideUp()
			.end()
			.find('.trx_importer_description_'+set).slideDown();
		// Show/hide set items
		set_form.find('[data-set-'+set+'="1"]').parent().show();
		set_form.find('[data-set-'+set+'="0"]').removeAttr('checked').parent().hide();
		if ( set == 'full' ) {
			jQuery('.trx_importer_part_pages').hide();
		} else {
			jQuery('.trx_importer_part_pages').show();
		}
		set_form.find('.trx_importer_item_posts').trigger('change');
		// Show/hide a block with a plugins settings
		var plugins = jQuery('.trx_importer_advanced_settings_block.trx_importer_advanced_settings_plugins'),
			visible = 0;
		plugins.find('>label').each( function() {
			if ( jQuery(this).css('display') != 'none' ) {
				visible++;
			}
		} );
		plugins.toggleClass( 'trx_addons_hidden', visible === 0 );
		// Change label
		set_form.find('[data-part-title]').each( function() {
			var $self = jQuery (this ),
				$caption = $self.next('.trx_importer_checkbox_caption');
			if ( $caption.length ) {
				if ( ! $self.data( 'full-title' ) ) {
					$self.data( 'full-title', $caption.text() );
				}
				$caption.text( $self.data( set + '-title' ) );
			}
		} );
		// Trigger scroll action
		jQuery( window ).trigger( 'scroll' );
	}
	
	// Start import
	jQuery('.trx_importer_section').on('click', '.trx_buttons input[type="button"]', function() {
		var steps = [];
		var demo_set = jQuery('#trx_importer_form [name="demo_set"]:checked').val();
		var demo_skin = jQuery( '.trx_importer_skins select' ).val();
		var demo_type = demo_set == 'part' && demo_skin
						? demo_skin
						: jQuery('#trx_importer_form [name="demo_type"]:checked').val();
		var demo_parts = '', demo_pages = '';
		// Collect parts to be imported
		jQuery(this).parents('form').find('input[type="checkbox"].trx_importer_item').each(function() {
			var name = jQuery(this).attr('name');
			if (jQuery(this).get(0).checked) {
				demo_parts += (demo_parts ? ',' : '') + name.substr(7); // Remove 'import_' from name - save only slug
				// Collect pages to be import on step 'import_posts'
				if (demo_set=='part' && name == 'import_posts') {
					jQuery('.trx_importer_part_pages input[type="checkbox"]').each(function() {
						if (jQuery(this).get(0).checked) {
							demo_pages += (demo_pages ? ',' : '') + jQuery(this).val();
						}
					});
				}
			} else {
				jQuery('#trx_importer_progress .'+name).hide();
			}
		});
		// Prepare steps for import
		jQuery(this).parents('form').find('input[type="checkbox"].trx_importer_item').each(function() {
			var name = jQuery(this).attr('name');
			if (jQuery(this).get(0).checked) {
				var step = {
					action: name,
					data: {
						demo_type: demo_type,
						demo_set: demo_set,
						demo_parts: demo_parts,
						demo_pages: demo_pages,
						start_from_id: 0
					}
				};
				steps.push(step);
			}
		});
		// Move 'uploads' and 'thumbnails' to the end of the list
		var uploads = false, thumbs = false, steps_list = '';
		for (var s=steps.length-1; s>=0; s--) {
			if (steps[s].action == 'import_uploads') {
				uploads = steps[s];
				steps.splice(s, 1);
			} else if (steps[s].action == 'import_thumbnails') {
				thumbs = steps[s];
				steps.splice(s, 1);
			} else {
				steps_list += (steps_list ? ', ' : '') + steps[s].action;
			}
		}
		if (uploads !== false) {
			steps.push(uploads);
			steps_list += (steps_list ? ', ' : '') + uploads.action;
		}
		if (thumbs !== false) {
			steps.push(thumbs);
			steps_list += (steps_list ? ', ' : '') + thumbs.action;
		}
		// Add start and end steps
		steps.unshift({
			action: 'import_start',
			data: { 
				demo_type: demo_type,
				demo_set: demo_set,
				demo_parts: demo_parts,
				demo_steps: steps_list
			}
		});
		steps.push({
			action: 'import_end',
			data: { 
				demo_type: demo_type,
				demo_set: demo_set,
				demo_parts: demo_parts
			}
		});
		// Hide Exporter
		jQuery('.trx_exporter_section').fadeOut();
		// Start banners rotator
		if (jQuery('.trx_banners_section').hasClass('trx_addons_hidden')) {
			jQuery('.trx_banners_section').removeClass('trx_addons_hidden');
			trx_addons_banners_rotator('.trx_banners_section');
		}
		// Start import
		trx_addons_document_animate_to('trx_addons_theme_panel_section_demo');
		jQuery('#trx_addons_theme_panel_section_demo .trx_addons_theme_panel_buttons').css('pointer-events', 'none');
		jQuery('#trx_importer_form').hide();
		jQuery('#trx_importer_progress').slideDown();
		TRX_ADDONS_STORAGE['importer_error_messages'] = '';
		TRX_ADDONS_STORAGE['importer_ignore_errors'] = true;
		trx_addons_importer_do_action( trx_addons_apply_filters( 'trx_addons_filters_importer_steps', steps ), 0 );
	});
	
	// Call specified action (step)
	function trx_addons_importer_do_action(steps, idx) {
		if ( !jQuery('#trx_importer_progress .'+steps[idx].action+' .import_progress_status').hasClass('step_in_progress') ) {
			jQuery('#trx_importer_progress .'+steps[idx].action+' .import_progress_status').addClass('step_in_progress').html('0%');
		}
		// AJAX query params
		var data = {
			'ajax_nonce': TRX_ADDONS_STORAGE['ajax_nonce'],
			'action': 'trx_addons_importer_start_import',
			'importer_action': steps[idx].action,
			'activate-multi': 1,
			is_admin_request: 1
		};
		// Additional params depend current step
		for (var i in steps[idx].data) {
			data[i] = steps[idx].data[i];
		}
		// Send request to server
		// Attention! Add activate-multi=1 to URL to prevent redirect from some plugins after options are updated
		jQuery.post( trx_addons_add_to_url( TRX_ADDONS_STORAGE['ajax_url'], { 'activate-multi': 1 } ), data, function( response ) {
			var rez = {}, pos = -1;
			try {
				if ( (pos = response.indexOf('{"action":')) >= 0 || (pos = response.indexOf('{"error":')) >= 0 || (pos = response.indexOf('{"data":')) >= 0 ) {
					response = response.substr(pos);
					rez = JSON.parse( response );
				} else {
					rez.error = TRX_ADDONS_STORAGE['msg_ajax_error'];
				}
			} catch (e) {
				rez = { error: TRX_ADDONS_STORAGE['msg_ajax_error']+':<br>'+response };
				console.log(response);
			}
			if ( rez.error === '' || TRX_ADDONS_STORAGE['importer_ignore_errors'] ) {
				if ( rez.error !== '' ) {
					TRX_ADDONS_STORAGE['importer_error_messages'] += '<span class="error_message">' + rez.error + '</span>';
				}
				var action = rez.action;
				if (rez.result === null || rez.result >= 100) {
					jQuery('#trx_importer_progress .'+action+' .import_progress_status').html('');
					jQuery('#trx_importer_progress .'+action+' .import_progress_status').removeClass('step_in_progress').addClass('step_complete'+(rez.error ? ' step_complete_with_error' : ''));
					idx++;
				} else {
					jQuery('#trx_importer_progress .'+action+' .import_progress_status').html(rez.result + '%');
					steps[idx].data['start_from_id'] = (typeof rez.start_from_id != 'undefined') ? rez.start_from_id : 0;
					steps[idx].data['attempt'] = (typeof rez.attempt != 'undefined') ? rez.attempt : 0;
				}
				// Do next action
				if (idx < steps.length) {
					trx_addons_importer_do_action(steps, idx);
				} else {
					if (TRX_ADDONS_STORAGE['importer_error_messages']) {
						jQuery('#trx_importer_progress')
							.removeClass('notice-info').addClass('notice-error')
							.find('.trx_importer_progress_result')
								.prepend(TRX_ADDONS_STORAGE['msg_importer_error'] + '<br>')
								.find('.trx_importer_progress_result_msg')
									.addClass('trx_importer_progress_error')
									.html(TRX_ADDONS_STORAGE['importer_error_messages']);
					} else {
						jQuery('#trx_importer_progress')
							.removeClass('notice-info').addClass('notice-success')
							.find('.trx_importer_progress_result_msg')
								.addClass('trx_importer_progress_complete');
					}
					jQuery('.trx_importer_progress_result').show();
					// Reload page after the import
					if (jQuery('.trx_addons_theme_panel').length > 0) {
						var need_reload = true;
						if (jQuery('.trx_addons_theme_panel .trx_addons_tabs').hasClass('trx_addons_panel_wizard')) {
							var $section_demo = jQuery( '#trx_addons_theme_panel_section_demo' );
							if ( $section_demo.next().length ) {
								trx_addons_set_cookie( 'trx_addons_theme_panel_wizard_section', 'trx_addons_theme_panel_section_demo' );
							} else {
								need_reload = false;
								$section_demo.find( '.trx_addons_theme_panel_buttons' ).css( 'pointer-events', 'auto' );
							}
						} else {
							if ( location.hash != 'trx_addons_theme_panel_section_qsetup' && jQuery('#trx_addons_theme_panel_section_qsetup').length > 0 ) {
								trx_addons_document_set_location( location.href.split('#')[0] + '#' + 'trx_addons_theme_panel_section_qsetup' );
							}
						}
						if ( need_reload ) {
							location.reload( true );
						}
					}
				}
			} else {
				// Add Error block above Import section
				jQuery('#trx_importer_progress').removeClass('notice-info').addClass('notice-error').css({'paddingTop': '1em', 'paddingBottom': '1em'}).html(rez.error);
			}
		} );
	}

} );
